#pragma once
#include "td_mp4.h"

typedef td_bool (*pMP4_IsMP4Format)(td_char* _pcFileName);
typedef td_MP4FileHandle* (*pMP4_Open) (td_char *_pcFileName);
typedef td_s32 (*pMP4_Close) (td_MP4FileHandle *_pMP4fh);
typedef td_s32 (*pMP4_GetFileHead)(td_MP4FileHandle *_pMP4fh, S_FileHeader *_pstMP4FileHead);
typedef td_s32 (*pMP4_GetEncryptStat)(td_MP4FileHandle *_pMP4fh, int* _piEncryptStat);
typedef td_s32 (*pMP4_GetSignInfo)(td_MP4FileHandle *_pMP4fh, ESignInfo _type, td_void **_pSignData, td_u32 *_dataLen);
typedef td_void (*pMP4_Free)(td_void *_pAddr);
typedef td_s32 (*pMP4_Read) (td_MP4FileHandle *_pMP4fh, td_void *_pFrameBuf, td_u32 _bufLen);
typedef td_s32 (*pMP4_Seek)(td_MP4FileHandle *_pMP4fh, td_u64 _frameId, ESeekOps _type);
typedef td_s32 (*pMP4_CopyMP4FileNoAudio)(char* _pcSrcFileName, char* _pcDstFileName);

class CLS_MP4Operation 
{
protected:
	CLS_MP4Operation();
public:
	~CLS_MP4Operation();
	static CLS_MP4Operation* Instance(void);
	static void Destroy();

	td_bool MP4_IsMP4Format(td_char* _pcFileName);
	td_MP4FileHandle* MP4_Open (td_char *_pcFileName);
	td_s32 MP4_Close(td_MP4FileHandle *_pMP4fh);
	td_s32 MP4_GetFileHead(td_MP4FileHandle *_pMP4fh, S_FileHeader *_pstMP4FileHead);
	td_s32 MP4_GetEncryptStat(td_MP4FileHandle *_pMP4fh, int* _piEncryptStat);
	td_s32 MP4_GetSignInfo(td_MP4FileHandle *_pMP4fh, ESignInfo _type, td_void **_pSignData, td_u32 *_dataLen);
	td_void MP4_Free(td_void *_pAddr);
	td_s32 MP4_Read(td_MP4FileHandle *_pMP4fh, td_void *_pFrameBuf, td_u32 _bufLen);
	td_s32 MP4_Seek(td_MP4FileHandle *_pMP4fh, td_u64 _frameId, ESeekOps _type);
	td_s32 MP4_CopyMP4FileNoAudio(char* _pcSrcFileName, char* _pcDstFileName);


private:
	static CLS_MP4Operation* m_pInstance;
	int LoadLibMp4();
	int FreeLibMp4();

	HINSTANCE				m_Handler;
	pMP4_IsMP4Format		m_MP4_IsMP4Format;
	pMP4_Open				m_MP4_Open;
	pMP4_Close				m_MP4_Close;
	pMP4_GetFileHead		m_MP4_GetFileHead;
	pMP4_GetEncryptStat		m_MP4_GetEncryptStat;
	pMP4_GetSignInfo		m_MP4_GetSignInfo;
	pMP4_Free				m_MP4_Free;
	pMP4_Read				m_MP4_Read;
	pMP4_Seek				m_MP4_Seek;
	pMP4_CopyMP4FileNoAudio m_MP4_CopyMP4FileNoAudio;
};